<?php
// dec2hex_form.php
// تبدیل Decimal → Hex (با فرم وب)
// نویسنده: ChatGPT

// استفاده از GMP در اولویت، در غیر این صورت BCMath.
function decToHexGmp(string $dec): string {
    $g = gmp_init($dec, 10);
    return gmp_strval($g, 16);
}

function decToHexBc(string $dec): string {
    $hex = '';
    $zero = '0';
    $sixteen = '16';
    while (bccomp($dec, $zero, 0) > 0) {
        $rem = bcmod($dec, $sixteen);
        $dec = bcdiv($dec, $sixteen, 0);
        $remHex = strtoupper(dechex((int)$rem));
        $hex = $remHex . $hex;
    }
    return strtolower($hex === '' ? '0' : $hex);
}

function decToHexAuto(string $dec): array {
    if (extension_loaded('gmp')) {
        return ['hex' => decToHexGmp($dec), 'backend' => 'GMP'];
    } elseif (extension_loaded('bcmath')) {
        return ['hex' => decToHexBc($dec), 'backend' => 'BCMath'];
    } else {
        throw new Exception("Neither GMP nor BCMath available.");
    }
}

function hexToBinary(string $hex): string {
    $bin = '';
    $len = strlen($hex);
    if ($len % 2 !== 0) $hex = '0'.$hex;
    $len = strlen($hex);
    for ($i = 0; $i < $len; $i++) {
        $digit = hexdec($hex[$i]);
        $bin .= str_pad(decbin($digit), 4, '0', STR_PAD_LEFT);
    }
    return $bin;
}

$input_raw = $_POST['decimal'] ?? '';
$errors = [];
$result = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dec = trim($input_raw);
    if ($dec === '') {
        $errors[] = "لطفاً یک عدد دهدهی وارد کنید.";
    } elseif (!preg_match('/^[0-9]+$/', $dec)) {
        $errors[] = "عدد دهدهی فقط باید شامل ارقام 0-9 باشد (بدون فاصله یا علامت).";
    } else {
        try {
            $data = decToHexAuto($dec);
            $hex = $data['hex'];
            $backend = $data['backend'];
            $bin = hexToBinary($hex);
            $result = [
                'dec' => $dec,
                'hex' => $hex,
                'backend' => $backend,
                'bin' => $bin,
                'bits' => strlen($bin),
                'bytes' => (int)(strlen($hex)/2),
                'hex_len' => strlen($hex)
            ];
        } catch (Exception $ex) {
            $errors[] = "خطا: ".$ex->getMessage();
        }
    }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>تبدیل Decimal به Hexadecimal</title>
<style>
body{font-family:Tahoma,Arial;background:#f7f9fb;color:#111;padding:20px}
.container{max-width:900px;margin:20px auto;background:#fff;padding:20px;border-radius:8px;box-shadow:0 6px 18px rgba(0,0,0,0.06)}
h1{margin-top:0;font-size:20px}
input[type=text]{width:100%;padding:10px;border:1px solid #ccc;border-radius:6px;font-family:monospace}
.btn{background:#0b79d0;color:#fff;border:none;padding:10px 14px;border-radius:6px;cursor:pointer}
pre{background:#0f1724;color:#c9e2ff;padding:12px;border-radius:6px;overflow:auto}
.warn{background:#fff4e5;border-left:4px solid #ffb020;padding:10px;margin:10px 0;border-radius:4px}
.small{font-size:13px;color:#666}
</style>
</head>
<body>
<div class="container">
<h1>تبدیل عدد دهدهی (Decimal) به هگزادسیمال (Hexadecimal)</h1>

<div class="warn small">
⚠️ هشدار: این ابزار فقط برای آموزش و تست است. از اعداد واقعی کلید خصوصی در محیط‌های آنلاین استفاده نکنید.
</div>

<form method="post">
<label>عدد دهدهی خود را وارد کنید:</label>
<input type="text" name="decimal" value="<?php echo htmlspecialchars($input_raw); ?>" placeholder="مثلاً: 1117653982188664..." autofocus>
<div style="margin-top:10px">
<button class="btn" type="submit">تبدیل کن</button>
<button class="btn" type="button" onclick="document.querySelector('input[name=decimal]').value='111765398218866455599161499737994639270090754107683193886635791750315474235441';">قرار دادن مثال</button>
</div>
</form>

<?php if ($errors): ?>
<div style="background:#ffecec;border-left:4px solid #f44336;padding:10px;margin-top:10px;border-radius:6px">
<strong>خطا:</strong>
<ul>
<?php foreach ($errors as $e): ?><li><?php echo htmlspecialchars($e); ?></li><?php endforeach; ?>
</ul>
</div>
<?php endif; ?>

<?php if ($result): ?>
<hr>
<h2>نتیجه تبدیل</h2>
<label>Decimal (دهدهی):</label>
<pre><?php echo htmlspecialchars($result['dec']); ?></pre>

<label>Hexadecimal (هگز) — backend: <?php echo htmlspecialchars($result['backend']); ?></label>
<pre id="hexOut"><?php echo htmlspecialchars($result['hex']); ?></pre>
<button class="btn" onclick="copyToClipboard('#hexOut')">کپی هگز</button>

<label>اطلاعات:</label>
<pre>
طول هگز: <?php echo $result['hex_len']; ?> کاراکتر
تعداد بایت: <?php echo $result['bytes']; ?>

طول باینری: <?php echo $result['bits']; ?> بیت
</pre>

<label>نمایش باینری (ابتدا و انتهای عدد):</label>
<pre><?php
$bin = $result['bin'];
$first = substr($bin, 0, 128);
$last = substr($bin, -128);
echo $first . "\n...\n" . $last;
?></pre>
<?php endif; ?>

</div>
<script>
function copyToClipboard(sel){
  const el=document.querySelector(sel);
  if(!el)return;
  const text=el.innerText||el.textContent;
  navigator.clipboard.writeText(text).then(()=>alert('کپی شد!')).catch(()=>alert('کپی نشد!'));
}
</script>
</body>
</html>
